unit graf_fx;

interface

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////////////////////}

type wielka_tablica = array[0..63999] of byte;

type obraz = record
              szerokosc : word;
              wysokosc : word;
              wsk_obrazu : ^wielka_tablica;
              rozmiar : word;
             end;

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;

type wzorzec_koloru = record
                       czerwony : byte;
                       zielony : byte;
                       niebieski : byte;
                      end;

{// N A G L O W K I  P R O C E D U R  I  F U N K C J I}
{///////////////////////////////////////////////////////}

procedure g_ustaw_tryb_vga(tryb : byte);
procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
procedure g_zamaluj_ekran_13h(kolor : byte);
procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);

implementation

procedure g_ustaw_tryb_vga(tryb : byte);
begin
asm

mov ah, 00h  {zaladuj 00h do AH - numer funkcji przerwania 10h}
mov al, tryb {zaladuj tryb do AL - numer trybu pracy karty graficznej}
int 10h      {wywolaj przerwanie 10h}

end;
end; {koniec procedury g_ustaw_tryb_vga}

{--------------}

procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
begin
asm

mov ax, y                {zaladuj y do AX}
mov di, ax               {zaladuj AX do DI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6                {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov ax, 0a000h           {zaladuj A000 do AX}
mov es, ax               {zaladuj AX do ES}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz pod adres ES:DI warto rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_13h}

{--------------}

procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
begin
asm
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax,y          {zaladuj y do AX}
mov di,ax         {zaladuj AX do DI}
shl ax,8          {przesun bity rejestru AX o 8 pozycji w lewo}
shl di,6          {przesun bity rejestru DI o 6 pozycji w lewo}
add di,ax         {dodaj AX do DI}
add di,x1         {dodaj x do DI}
mov ax,0a000h     {zaladuj A000 do AX}
mov es,ax         {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;
end; {koniec procedury g_rysuj_pozioma_linia_13h}

{--------------}

procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
begin
asm

mov cx, y2        {zaladuj y2 do CX}
sub cx, y1        {odejmij y1 od CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y1        {zaladuj 1 do AX}
mov di, ax        {zaladuj AX do DI}
shl ax, 8         {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6         {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax        {dodaj AX do DI}
add di, x         {dodaj x do DI}
mov ax, 0a000h    {zaladuj A000 do AX}
mov es, ax        {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}

@rysuj_linie:     {definicja etykiety}
mov es:[di], al   {zapisz AL do komorki pamieci o adresie ES:DI}
add di, 320       {dodaj 320 do DI}
loop @rysuj_linie {zmiejsz CX o 1, jezeli rozny od 0 skocz do etykiety rysuj_linie}

end;
end; {koniec procedury g_rysuj_pionowa_linia_13h}

{--------------}

procedure g_zamaluj_ekran_13h(kolor : byte);
begin
asm

mov ax, 0A000h   {zaladuj A000h do AX}
mov es, ax       {zaladuj AX do ES}
mov di, 0        {zaladuj 0 do DI}
mov cx, 32000    {zaladuj 32000 do CX} 
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_zamaluj_ekran_13h}

{--------------}

procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
var
plik : file;
naglowek : naglowek_pliku_BMP;
licznik, wynik : word;
licznik_odczytu : word;
begin

{Skojarzenie zbiory ze zmienna plikowa i otworzenie go}
assign(plik, szciezka);
reset(plik, 1);

{odczyt naglowka bitmapy}
licznik := sizeof(naglowek_pliku_BMP);
blockread(plik, naglowek, licznik, wynik);

{Sprawdzenie czy rozmiary obrazu sa zgodne z rozdzielczoscia ekranu }
if((naglowek.szerokosc_obrazu > 320) or
   (naglowek.wysokosc_obrazu > 200)) then
   begin
   close(plik);   {zamkniecie pliku}
   exit;          {opuszczenie procedury}
   end;  {koniec if then}

{przeskakujemy palete kolorow}
seek(plik,1078);

{zapisanie rozmiarow obrazu i oblicznie rozmiaru bloku pamieci
 potrzebnego do przechowywania obrazu}
z_obraz.szerokosc := naglowek.szerokosc_obrazu;
z_obraz.wysokosc := naglowek.wysokosc_obrazu;
z_obraz.rozmiar := naglowek.szerokosc_obrazu * naglowek.wysokosc_obrazu;

{Sparwdzamy czy system posiada dosc wolen pamieci do przechowywania
 ladowanego obrazu bitmapy, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < z_obraz.rozmiar) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla obrazu}
getmem(z_obraz.wsk_obrazu, z_obraz.rozmiar);

{zaladowanie obrazu - obraz podczas odczytu zostaje odwrucony w pionie}
licznik := naglowek.szerokosc_obrazu;
for licznik_odczytu := 0 to naglowek.wysokosc_obrazu - 1 do
begin
blockread(plik, z_obraz.wsk_obrazu^[(naglowek.wysokosc_obrazu - 1 - licznik_odczytu) * z_obraz.szerokosc], licznik, wynik);
end; {koniec petli for}

{zamkniecie pliku}
close(plik);

end; {koniec procedury g_laduj_BMP_13h}

end. {koniec modulu}